﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace NovelInterpreter.Compiler
{
	/// <summary>
	/// 正規表現によるKAGのマッチング
	/// </summary>
	public class RegexParser
	{
		/// <summary>
		/// KAGの構文でマッチングを行い、結果を返す
		/// </summary>
		/// <param name="data">マッチングを行いたい文字列</param>
		/// <returns>マッチした順番で格納されたリスト</returns>
		public static List<string> Matches(string data)
		{
			List<string> result = new List<string>();
			Regex.Replace(data, "^[ 　\\t]+\\n", "");	// 空白行の削除

			MatchCollection matchCollection = Regex.Matches(
				data, "(\\s*//[\\w\\t !-~]*$)|\\s*/\\*[\\w\\W]*\\*/$|(\\[\\w+(\\s\\w+=((\\w+)|(\\\"([\\w\\n\\s!#-Z^-~]|(\\\\\\\"|\\\\\\[|\\\\\\]|\\\\\\\\))+\\\")))*\\])|(@\\w+(\\s\\w+=((\\w+)|(\\\"([\\w\\n\\s!#-Z^-~]|(\\\\\\\"|\\\\\\[|\\\\\\]|\\\\\\\\))+\\\"))*)$)|(\\*\\w+\\|\\w+$)|((\\w|[^\\w/\\@\\n\\[\\]\\\\]|(\\\\\\[|\\\\\\]|\\\\\\\\|\\\\/))+$)"
				);

			foreach (Match match in matchCollection)
			{
				Console.WriteLine(match);
				result.Add(match.Value);
			}

			return result;
		}

		/// <summary>
		/// 指定したマッチパターンから結果を返す
		/// </summary>
		/// <param name="data">マッチングを行いたい文字列</param>
		/// <param name="pattern">マッチした順番で格納されたリスト</param>
		/// <returns></returns>
		public static List<string> Matches(string data, string pattern)
		{
			List<string> reslut = new List<string>();
			MatchCollection matchCollection = Regex.Matches(data, pattern);

			foreach (Match match in matchCollection)
				reslut.Add(match.Value);

			return reslut;
		}

	}
}
